define('lodashDatestrMixin', ['underscore'],
    function (_) {
        var isDateString = function (value) {
            return value && !isNaN(Date.parse(value)) || false;
        };

        var toTitleCase = function(string) {
            return string.replace(/\w*/g, function(txt) {
                return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
            });
        };

        _.isDateString = isDateString;

        _.toTitleCase = toTitleCase;
    }
);
